# راهنمای تنظیمات Mini App

## تنظیمات اولیه

### 1. تنظیم نام کاربری ربات
فایل `js/app.js` را باز کرده و نام کاربری ربات خود را در متغیر زیر قرار دهید:

```javascript
const BOT_USERNAME = 'YourBotUsername'; // مثال: 'MyFileUploaderBot'
```

### 2. راه‌اندازی

#### روش 1: سرور Python
```bash
cd web
python3 -m http.server 8000
```

سپس به آدرس `http://localhost:8000` بروید.

#### روش 2: سرور PHP
```bash
cd web
php -S localhost:8000
```

### 3. قابلیت‌های Mini App

- ✅ نمایش اطلاعات کاربر
- ✅ نمایش اخطارها (تا 3 اخطار)
- ✅ نمایش فایل‌های دانلود شده
- ✅ کلیک روی فایل → نمایش جزئیات در پاپ‌آپ iOS 26
- ✅ دکمه دانلود → باز کردن ربات برای دانلود
- ✅ سیستم اعتراض برای کاربران بن شده
- ✅ نوتیفیکیشن Toast برای عملیات‌ها
- ✅ تم iOS 26 با Glassmorphism
- ✅ فونت فارسی Vazirmatn
- ✅ آیکون‌های Font Awesome
- ✅ **دارک مود با تغییر خودکار و دکمه Toggle**
- ✅ ذخیره تنظیمات تم در localStorage
- ✅ طراحی Responsive برای موبایل

### 4. تست با کاربر نمونه

اگر خارج از تلگرام باز شود، دکمه "ورود با کاربر نمونه (تست)" نمایش داده می‌شود که:
- کاربری با 3 اخطار
- وضعیت بن شده
- 5 فایل نمونه

### 5. یکپارچه‌سازی با ربات

برای اتصال به ربات، در فایل `bot.php` دستور `/start` را طوری تنظیم کنید که:

```php
if (preg_match('/^download_(.+)$/', $startParam, $matches)) {
    $fileId = $matches[1];
    // Send file to user
}
```

### 6. API Endpoints

- `POST /api.php` با `action: getUserData` → دریافت اطلاعات کاربر
- `POST /api.php` با `action: submitAppeal` → ثبت اعتراض
