<?php
/**
 * فایل تنظیم webhook
 * Setup Webhook Script
 * 
 * برای تنظیم webhook، این فایل را در مرورگر باز کنید
 */

require_once 'config.php';

echo "<h1>🤖 تنظیم Webhook ربات تلگرام</h1>";

// آدرس webhook
$webhookUrl = DOMAIN . '/index.php';

echo "<p><strong>آدرس Webhook:</strong> {$webhookUrl}</p>";

// ارسال درخواست تنظیم webhook
$url = API_URL . "setWebhook?url=" . urlencode($webhookUrl);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$result = curl_exec($ch);
curl_close($ch);

$response = json_decode($result, true);

echo "<h2>نتیجه:</h2>";
echo "<pre>";
print_r($response);
echo "</pre>";

if ($response['ok']) {
    echo "<p style='color: green; font-size: 18px;'>✅ Webhook با موفقیت تنظیم شد!</p>";
    echo "<p>می‌توانید این فایل را حذف کنید.</p>";
} else {
    echo "<p style='color: red; font-size: 18px;'>❌ خطا در تنظیم Webhook!</p>";
    echo "<p>لطفا تنظیمات config.php را بررسی کنید.</p>";
}

echo "<hr>";
echo "<h2>بررسی وضعیت Webhook:</h2>";

// دریافت اطلاعات webhook
$infoUrl = API_URL . "getWebhookInfo";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $infoUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$infoResult = curl_exec($ch);
curl_close($ch);

$webhookInfo = json_decode($infoResult, true);

echo "<pre>";
print_r($webhookInfo);
echo "</pre>";

?>
