<?php
/**
 * سیستم آپلود پیشرفته
 * Advanced Upload System
 */

class FileUploader {
    
    /**
     * دانلود فایل از URL
     */
    public static function downloadFromUrl($url, $destination) {
        $ch = curl_init($url);
        $fp = fopen($destination, 'wb');
        
        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
        
        // Progress callback
        curl_setopt($ch, CURLOPT_NOPROGRESS, false);
        curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, function($resource, $download_size, $downloaded, $upload_size, $uploaded) {
            if ($download_size > 0) {
                $percent = round(($downloaded / $download_size) * 100);
                // می‌توان درصد را ذخیره کرد
            }
        });
        
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        curl_close($ch);
        fclose($fp);
        
        if ($result && $httpCode == 200) {
            return true;
        }
        
        @unlink($destination);
        return false;
    }
    
    /**
     * آپلود فایل به تلگرام از مسیر محلی
     */
    public static function uploadToTelegram($chatId, $filePath, $fileType = 'document') {
        $method = 'sendDocument';
        
        if ($fileType == 'photo') {
            $method = 'sendPhoto';
            $fileParam = 'photo';
        } elseif ($fileType == 'video') {
            $method = 'sendVideo';
            $fileParam = 'video';
        } elseif ($fileType == 'audio') {
            $method = 'sendAudio';
            $fileParam = 'audio';
        } else {
            $fileParam = 'document';
        }
        
        $url = API_URL . $method;
        
        $data = [
            'chat_id' => $chatId,
            $fileParam => new CURLFile($filePath)
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $result = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($result, true);
    }
    
    /**
     * دریافت اطلاعات فایل از URL
     */
    public static function getFileInfoFromUrl($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        curl_exec($ch);
        
        $size = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
        $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
        
        curl_close($ch);
        
        // استخراج نام فایل از URL
        $fileName = basename(parse_url($url, PHP_URL_PATH));
        if (empty($fileName)) {
            $fileName = 'download_' . time();
        }
        
        return [
            'size' => $size,
            'type' => $contentType,
            'name' => $fileName
        ];
    }
    
    /**
     * تشخیص نوع فایل از extension
     */
    public static function detectFileType($fileName) {
        $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        $imageExts = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
        $videoExts = ['mp4', 'avi', 'mkv', 'mov', 'wmv', 'flv', 'webm'];
        $audioExts = ['mp3', 'wav', 'ogg', 'flac', 'm4a', 'aac'];
        
        if (in_array($ext, $imageExts)) {
            return 'photo';
        } elseif (in_array($ext, $videoExts)) {
            return 'video';
        } elseif (in_array($ext, $audioExts)) {
            return 'audio';
        }
        
        return 'document';
    }
    
    /**
     * ساخت پیشنمایش اطلاعات فایل
     */
    public static function generatePreview($fileData) {
        $message = "📋 " . HTMLParser::format("پیشنمایش فایل", true) . "\n\n";
        
        if (!empty($fileData['title'])) {
            $message .= "🏷 تایتل: " . HTMLParser::format($fileData['title'], true) . "\n";
        }
        
        $message .= "📁 نام: " . HTMLParser::format($fileData['file_name'], false, false, true) . "\n";
        $message .= "💾 حجم: " . HTMLParser::format(HTMLParser::formatFileSize($fileData['file_size'])) . "\n";
        $message .= "📊 نوع: " . HTMLParser::format($fileData['type']) . "\n\n";
        
        if (!empty($fileData['caption'])) {
            $message .= "💬 کپشن:\n";
            $message .= HTMLParser::blockquote($fileData['caption']) . "\n\n";
        }
        
        if ($fileData['download_limit'] > 0) {
            $message .= "🔢 محدودیت دانلود: " . HTMLParser::format($fileData['download_limit'], true) . "\n";
        } else {
            $message .= "🔢 محدودیت دانلود: " . HTMLParser::format("نامحدود", true) . "\n";
        }
        
        if (isset($fileData['expire_days']) && $fileData['expire_days'] > 0) {
            $message .= "⏰ انقضا: " . HTMLParser::format($fileData['expire_days'] . " روز", true) . "\n";
        } else {
            $message .= "⏰ انقضا: " . HTMLParser::format("ندارد", true) . "\n";
        }
        
        $forceJoinStatus = $fileData['force_join_enabled'] ? '✅ فعال' : '❌ غیرفعال';
        $message .= "🔗 جوین اجباری: " . HTMLParser::format($forceJoinStatus, true) . "\n";
        
        if (!empty($fileData['password'])) {
            $message .= "🔐 رمز عبور: " . HTMLParser::format("✅ فعال", true) . "\n";
        }
        
        $message .= "\n";
        
        $message .= HTMLParser::blockquote("آیا می‌خواهید این فایل را آپلود کنید؟");
        
        return $message;
    }
}
